/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.compat.jei.alchemytable.AlchemyTableRecipeCategory;
import wayoftime.bloodmagic.compat.jei.alchemytable.PotionRecipeCategory;
import wayoftime.bloodmagic.compat.jei.altar.BloodAltarRecipeCategory;
import wayoftime.bloodmagic.compat.jei.arc.ARCFurnaceRecipeCategory;
import wayoftime.bloodmagic.compat.jei.arc.ARCRecipeCategory;
import wayoftime.bloodmagic.compat.jei.array.AlchemyArrayCraftingCategory;
import wayoftime.bloodmagic.compat.jei.forge.TartaricForgeRecipeCategory;
import wayoftime.bloodmagic.impl.BloodMagicAPI;

@JeiPlugin
public class BloodMagicJEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelper;
    private static final ResourceLocation ID;

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.SOUL_FORGE.get()), new ResourceLocation[]{TartaricForgeRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.BLOOD_ALTAR.get()), new ResourceLocation[]{BloodAltarRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicItems.ARCANE_ASHES.get()), new ResourceLocation[]{AlchemyArrayCraftingCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get()), new ResourceLocation[]{ARCRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get()), new ResourceLocation[]{ARCFurnaceRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMY_TABLE.get()), new ResourceLocation[]{AlchemyTableRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMY_TABLE.get()), new ResourceLocation[]{PotionRecipeCategory.UID});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelper = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new TartaricForgeRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BloodAltarRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AlchemyArrayCraftingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ARCRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ARCFurnaceRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AlchemyTableRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PotionRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        registration.addRecipes(BloodMagicAPI.INSTANCE.getRecipeRegistrar().getTartaricForgeRecipes((Level)world), TartaricForgeRecipeCategory.UID);
        registration.addRecipes(BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAltarRecipes((Level)world), BloodAltarRecipeCategory.UID);
        registration.addRecipes(BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyArrayRecipes((Level)world), AlchemyArrayCraftingCategory.UID);
        registration.addRecipes(BloodMagicAPI.INSTANCE.getRecipeRegistrar().getARCRecipes((Level)world), ARCRecipeCategory.UID);
        registration.addRecipes((Collection)ImmutableSet.copyOf((Collection)world.m_7465_().m_44013_(RecipeType.f_44108_)), ARCFurnaceRecipeCategory.UID);
        registration.addRecipes(BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyTableRecipes((Level)world), AlchemyTableRecipeCategory.UID);
        registration.addRecipes(BloodMagicAPI.INSTANCE.getRecipeRegistrar().getPotionFlaskRecipes((Level)world), PotionRecipeCategory.UID);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    static {
        ID = BloodMagic.rl("jei_plugin");
    }
}

